# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 9
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR9_strategy.txt
# LLM Suggested Fallback: D

def enigmatic_symphony(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Early Game (Rounds 1-3)
    if current_round == 1:
        return "C"
    elif current_round == 2:
        return "D"
    elif current_round == 3:
        if len(opp_history) >= 1 and opp_history[0] == "C":
            return "C"
        else:
            return "D"
    
    # Mid-Game (Rounds 4-7)
    elif current_round <= 7:
        if len(opp_history) >= 2 and opp_history[0] == "C" and opp_history[1] == "D":
            return "D"
        elif len(opp_history) >= 2 and opp_history[0] == "C" and opp_history[1] == "C":
            return "D" if current_round % 2 == 0 else "C"
        else:
            return opp_history[-1] if opp_history else "D"
    
    # Late Game (Rounds 8-10)
    else:
        coop_count = opp_history.count("C")
        defect_count = opp_history.count("D")
        if coop_count > defect_count:
            return "C"
        elif defect_count > coop_count:
            return "D"
        else:
            return "D" if current_round == 10 else "C"